// Copyright 2014 Google Inc. All Rights Reserved.

#include "GalVerificationVendorExtensionCallbackRouter.h"

int GalVerificationVendorExtensionCallbackRouter::dataAvailable(
        uint8_t* data, size_t len) {
    uint16_t type = (uint16_t)(*data++) << 8;
    type |= *data++;
    len -= sizeof(uint16_t);
    int ret = STATUS_UNEXPECTED_MESSAGE;
    switch (type) {
        case GAL_VERIFICATION_SET_SENSOR: {
            GalVerificationSetSensor sensor;
            if (PARSE_PROTO(sensor, data, len)) {
                ret = mCallbacks->injectSensorDataCallback(sensor);
            }
            break;
        }
        case GAL_VERIFICATION_VIDEO_FOCUS: {
            GalVerificationVideoFocus videoFocus;
            if (PARSE_PROTO(videoFocus, data, len)) {
                ret = mCallbacks->setVideoFocusCallback(videoFocus);
            }
            break;
        }
        case GAL_VERIFICATION_INJECT_INPUT: {
            GalVerificationInjectInput input;
            if (PARSE_PROTO(input, data, len)) {
                ret = mCallbacks->injectInputCallback(input);
            }
            break;
        }
        case GAL_VERIFICATION_SCREEN_CAPTURE_REQUEST: {
            GalVerificationScreenCaptureRequest request;
            if (PARSE_PROTO(request, data, len)) {
                ret = mCallbacks->requestScreenCaptureCallback(request);
            }
            break;
        }
        case GAL_VERIFICATION_DISPLAY_INFORMATION_REQUEST: {
            GalVerificationDisplayInformationRequest request;
            if (PARSE_PROTO(request, data, len)) {
                ret = mCallbacks->requestDisplayInformationCallback(request);
            }
            break;
        }
        case GAL_VERIFICATION_BUG_REPORT_REQUEST:
            // TODO: Implement additional debug messages.
            break;
        case GAL_VERIFICATION_AUDIO_FOCUS: {
            GalVerificationAudioFocus request;
            if (PARSE_PROTO(request, data, len)) {
                ret = mCallbacks->requestAudioFocusChangeCallback(request);
            }
            break;
        }
        default:
            // Default return code of STATUS_UNEXPECTED_MESSAGE.
            break;
    }
    return ret;
}
